/*** DTB_USER_CODE_START vvv Add file header below vvv ***/
/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/*** DTB_USER_CODE_END   ^^^ Add file header above ^^^ ***/

/*
 * File: cgen_env_stubs.c
 * Contains: Module callbacks and connection functions
 *
 * This file was generated by dtcodegen, from module cgen_env
 *
 * Any text may be added between the DTB_USER_CODE_START and
 * DTB_USER_CODE_END comments (even non-C code). Descriptive comments
 * are provided only as an aid.
 *
 *  ** EDIT ONLY WITHIN SECTIONS MARKED WITH DTB_USER_CODE COMMENTS.  **
 *  ** ALL OTHER MODIFICATIONS WILL BE OVERWRITTEN. DO NOT MODIFY OR  **
 *  ** DELETE THE GENERATED COMMENTS!                                 **
 */

#include <stdint.h>
#include <stdio.h>
#include <Xm/Xm.h>
#include "dtb_utils.h"
#include "dtbuilder.h"
#include "cgen_env_ui.h"


/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All necessary header files have been included.
 ***
 *** Add include files, types, macros, externs, and user functions here.
 ***/

#include <Xm/TextF.h>
#include <Xm/Text.h>

#include "dtbuilder.h"
#include "cgen_env_ui.h"
#include <ab_private/strlist.h>
#include "palette_ui.h"
#include "cgen.h"
#include "dtb_utils.h"

/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/



void 
cgenP_get_envCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    DtbCgenEnvDialogInfo        env_dlg = (DtbCgenEnvDialogInfo)clientData;
    STRING                      var_name = NULL;
    STRING                      var_value = NULL;
    int                         index = 0;

    var_name = XmTextFieldGetString(env_dlg->name_textf);
    if (util_strempty(var_name))
    {
	/* clean out the value textpane */
	XmTextSetString(env_dlg->textpane, NULL);
    }
    else
    {
        if (strlist_str_exists(user_env_vars, var_name))
        {
            var_value = (STRING) strlist_get_str_data(user_env_vars, var_name);
        }
        else
        {
            /* not in list */
            var_value = getenv(var_name);
        }
	if (var_value == NULL)
	{
	    XmTextSetString(env_dlg->textpane, CATGETS(Dtb_project_catd, 100, 58, "*** Not Set ***"));
	}
	else
	{
	    XmTextSetString(env_dlg->textpane, var_value);
	}
	
    }

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
cgenP_set_envCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    DtbCgenEnvDialogInfo        env_dlg = (DtbCgenEnvDialogInfo)clientData;
    STRING                      var_name = NULL;
    STRING                      var_value = NULL;
    STRING                      old_var_value = NULL;

    var_name = XmTextFieldGetString(env_dlg->name_textf);

    if (util_strempty(var_name))
        return;

    var_value = XmTextGetString(env_dlg->textpane);

    if (strlist_str_exists(user_env_vars, var_name))
    {
        /* the user has set this before - we need to deallocate
         * the string we allocated
         */
        old_var_value = (STRING) strlist_get_str_data(user_env_vars, var_name);
        util_free(old_var_value);
        strlist_remove_str(user_env_vars, var_name);
    }
    if (!util_strempty(var_value))
        strlist_add_str(user_env_vars, var_name, (void *)strdup(var_value));
    else
        strlist_add_str(user_env_vars, var_name, (void *)NULL);

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
cgenP_reset_envCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/
    DtbCgenEnvDialogInfo        env_dlg = (DtbCgenEnvDialogInfo)clientData;
    STRING                      var_name = NULL;
    STRING                      var_value = NULL;

    var_name = XmTextFieldGetString(env_dlg->name_textf);

    if (util_strempty(var_name))
        return;

    if (strlist_str_exists(user_env_vars, var_name))
    {
        /* the user has set this before - we need to deallocate
         * the string we allocated
         */
        var_value = (STRING) strlist_get_str_data(user_env_vars, var_name);
        util_free(var_value);
        strlist_remove_str(user_env_vars, var_name);
    }
    var_value = getenv(var_name);

    if (var_value == NULL)
    {
	XmTextSetString(env_dlg->textpane, CATGETS(Dtb_project_catd, 100, 58, "*** Not Set ***"));
    }
    else
    {
	XmTextSetString(env_dlg->textpane, var_value);
    }

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
cgenP_init_env_list(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    DtbCgenEnvDialogInfo	dtbSource = (DtbCgenEnvDialogInfo)callData;
    
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    if (user_env_vars == NULL)
    {
        user_env_vars = strlist_create();
    }

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
cgenP_cancel_envCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/
    DtbCgenEnvDialogInfo        env_dlg = (DtbCgenEnvDialogInfo)clientData;
    char buf[10];

    sprintf(buf, "%s", "");
    XmTextFieldSetString(env_dlg->name_textf, buf);
    XmTextSetString(env_dlg->textpane, buf);
    
    XtPopdown(env_dlg->dialog);

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}



/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All automatically-generated data and functions have been defined.
 ***
 *** Add new functions here, or at the top of the file.
 ***/
/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/


