/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/* $XConsortium: DndIconI.h /main/3 1995/10/26 15:05:58 rswiston $ */
/*********************************************************************
 *
 *	File:		DndIconI.h
 *
 *	Description:	Private include file containing DND drag icons bitmaps
 *
 *********************************************************************
 *
 *+SNOTICE
 *
 *	RESTRICTED CONFIDENTIAL INFORMATION:
 *	
 *	The information in this document is subject to special
 *	restrictions in a confidential disclosure agreement between
 *	HP, IBM, Sun, USL, SCO and Univel.  Do not distribute this
 *	document outside HP, IBM, Sun, USL, SCO, or Univel without
 *	Sun's specific written approval.  This documment and all copies
 *	and derivative works thereof must be returned or destroyed at
 *	Sun's request.
 *
 *	Copyright 1993 Sun Microsystems, Inc.  All rights reserved.
 *
 * (c) Copyright 1993, 1994 Hewlett-Packard Company
 * (c) Copyright 1993, 1994 International Business Machines Corp.
 * (c) Copyright 1993, 1994 Sun Microsystems, Inc.
 * (c) Copyright 1993, 1994 Novell, Inc.
 *
 *+ENOTICE
 */

#ifndef _Dt_DndIconI_h
#define _Dt_DndIconI_h

#ifdef __cplusplus
extern "C" {
#endif


/*-------------------------------------------------------------------
 *	Motif Defaults
 *-------------------------------------------------------------------*/

#define	motif_x_hot		 1
#define	motif_y_hot		 1

#define motif_x_offset_state	-8	
#define motif_y_offset_state	-2

#define motif_x_offset_delta	 0
#define motif_y_offset_delta	 0

/*-------------------------------------------------------------------
 *	Text Drags: Cursors
 *-------------------------------------------------------------------*/

#define	text_x_hot		 1
#define	text_y_hot		 1

#define text_x_offset_state	 1
#define text_y_offset_state	 1

#define text_x_offset_delta	 7
#define text_y_offset_delta	 3

/*
 *	Text: State Valid
 */

#define text_valid_width 16
#define text_valid_height 16

static unsigned char text_valid_bits[] = {
#ifdef OLDTEXTVALID
   0x00, 0x00, 0x02, 0x00, 0x06, 0x00, 0x0e, 0x00, 0x1e, 0x00, 0x3e, 0x00,
   0x7e, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#else
   0x00, 0x00, 0xfe, 0x01, 0xfe, 0x00, 0x7e, 0x00, 0x3e, 0x00, 0x1e, 0x00,
   0x0e, 0x00, 0x06, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#endif

static unsigned char text_valid_m_bits[] = {
#ifdef OLDTEXTVALID
   0x03, 0x00, 0x07, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x3f, 0x00, 0x7f, 0x00,
   0xff, 0x00, 0xff, 0x01, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#else
   0xff, 0x07, 0xff, 0x03, 0xff, 0x01, 0xff, 0x00, 0x7f, 0x00, 0x3f, 0x00,
   0x1f, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#endif

/*
 *	Text: State Invalid
 */

#define text_invalid_width 16
#define text_invalid_height 16

static unsigned char text_invalid_bits[] = {
   0x00, 0x00, 0xe0, 0x03, 0xf8, 0x0f, 0x1c, 0x1c, 0x0c, 0x1e, 0x06, 0x37,
   0x86, 0x33, 0xc6, 0x31, 0xe6, 0x30, 0x76, 0x30, 0x3c, 0x18, 0x1c, 0x1c,
   0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00};

static unsigned char text_invalid_m_bits[] = {
   0xe0, 0x03, 0xf8, 0x0f, 0xfc, 0x1f, 0xfe, 0x3f, 0x1e, 0x3f, 0x8f, 0x7f,
   0xcf, 0x7f, 0xef, 0x7b, 0xff, 0x79, 0xff, 0x78, 0x7e, 0x3c, 0xfe, 0x3f,
   0xfc, 0x1f, 0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00};

/*
 *	Text: None
 */

#define text_none_width 16
#define text_none_height 16

static unsigned char text_none_bits[] = {
   0x00, 0x00, 0xe0, 0x03, 0xf8, 0x0f, 0x1c, 0x1c, 0x0c, 0x1e, 0x06, 0x37,
   0x86, 0x33, 0xc6, 0x31, 0xe6, 0x30, 0x76, 0x30, 0x3c, 0x18, 0x1c, 0x1c,
   0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00};

static unsigned char text_none_m_bits[] = {
   0xe0, 0x03, 0xf8, 0x0f, 0xfc, 0x1f, 0xfe, 0x3f, 0x1e, 0x3f, 0x8f, 0x7f,
   0xcf, 0x7f, 0xef, 0x7b, 0xff, 0x79, 0xff, 0x78, 0x7e, 0x3c, 0xfe, 0x3f,
   0xfc, 0x1f, 0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00};

/*-------------------------------------------------------------------
 *	Text Drags: Operation Cursors
 *-------------------------------------------------------------------*/

/* Use Data Operation Cursors */

/*
 *	Text: Operation Move
 */

/*
 *	Text: Operation Copy
 */

/*
 *	Text: Operation Link
 */

/*-------------------------------------------------------------------
 *	Text Drags: Source Cursor
 *-------------------------------------------------------------------*/

#define text_source_width 32
#define text_source_height 32

static unsigned char text_source_bits[] = {
#ifdef OLDTEXTSOURCE
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xd8, 0xdb, 0xcd, 0x0d, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xbe, 0x7f, 0x1f,
   0x00, 0x00, 0x00, 0x00, 0xb8, 0xf6, 0xfd, 0x16, 0x00, 0x00, 0x00, 0x00,
   0xe8, 0x7b, 0x76, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xbb, 0xff, 0x06,
   0x00, 0x00, 0x00, 0x00, 0xd8, 0xde, 0x7b, 0x1d, 0x00, 0x00, 0x00, 0x00,
   0x78, 0xd7, 0xb4, 0x0b, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xad, 0xd5, 0x0f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#else
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0xcd, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x7f, 0x1f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfd, 0x16, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x7b, 0x76, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xbb, 0xff, 0x06,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0xde, 0x7b, 0x1d, 0x00, 0x00, 0x00, 0x00,
   0x78, 0x77, 0xb7, 0x0b, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xbd, 0xdd, 0x0f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#endif

static unsigned char text_source_m_bits[] = {
#ifdef OLDTEXTSOURCE
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#else
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3f,
   0x00, 0xf0, 0xff, 0x3f, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0xfc, 0xff, 0x3f,
   0x00, 0xfe, 0xff, 0x3f, 0x00, 0xff, 0xff, 0x3f, 0x80, 0xff, 0xff, 0x3f,
   0xc0, 0xff, 0xff, 0x3f, 0xe0, 0xff, 0xff, 0x3f, 0xf0, 0xff, 0xff, 0x3f,
   0xf8, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x3f,
   0xfc, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#endif

/*-------------------------------------------------------------------
 *	Data Drags: Cursors
 *------------------------------------------------------------------*/

#define	data_x_hot		 3
#define	data_y_hot		 3

#define data_x_offset_state	11
#define data_y_offset_state	11

#define data_x_offset_delta	 7
#define data_y_offset_delta	 7

/*
 *	Data: State Valid
 */

#define data_valid_width 16
#define data_valid_height 16

static unsigned char data_valid_bits[] = {
   0x00, 0x00, 0x06, 0x00, 0x1e, 0x00, 0x7c, 0x00, 0xfc, 0x01, 0xf8, 0x07,
   0xf8, 0x07, 0xf0, 0x01, 0xf0, 0x03, 0x60, 0x07, 0x60, 0x0e, 0x00, 0x1c,
   0x00, 0x38, 0x00, 0x70, 0x00, 0x60, 0x00, 0x00};

static unsigned char data_valid_m_bits[] = {
   0x07, 0x00, 0x1f, 0x00, 0x7f, 0x00, 0xfe, 0x01, 0xfe, 0x07, 0xfc, 0x0f,
   0xfc, 0x0f, 0xf8, 0x07, 0xf8, 0x07, 0xf0, 0x0f, 0xf0, 0x1f, 0x60, 0x3e,
   0x00, 0x7c, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0x60};

/*
 *	Data: State Invalid
 */

#define data_invalid_width 16
#define data_invalid_height 16

static unsigned char data_invalid_bits[] = {
   0x00, 0x00, 0xe0, 0x03, 0xf8, 0x0f, 0x1c, 0x1c, 0x0c, 0x1e, 0x06, 0x37,
   0x86, 0x33, 0xc6, 0x31, 0xe6, 0x30, 0x76, 0x30, 0x3c, 0x18, 0x1c, 0x1c,
   0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00};

static unsigned char data_invalid_m_bits[] = {
   0xe0, 0x03, 0xf8, 0x0f, 0xfc, 0x1f, 0xfe, 0x3f, 0x1e, 0x3f, 0x8f, 0x7f,
   0xcf, 0x7f, 0xef, 0x7b, 0xff, 0x79, 0xff, 0x78, 0x7e, 0x3c, 0xfe, 0x3f,
   0xfc, 0x1f, 0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00};

/*
 *	Data: State None
 */

#define data_none_width 16
#define data_none_height 16

static unsigned char data_none_bits[] = {
   0x00, 0x00, 0xe0, 0x03, 0xf8, 0x0f, 0x1c, 0x1c, 0x0c, 0x1e, 0x06, 0x37,
   0x86, 0x33, 0xc6, 0x31, 0xe6, 0x30, 0x76, 0x30, 0x3c, 0x18, 0x1c, 0x1c,
   0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00};

static unsigned char data_none_m_bits[] = {
   0xe0, 0x03, 0xf8, 0x0f, 0xfc, 0x1f, 0xfe, 0x3f, 0x1e, 0x3f, 0x8f, 0x7f,
   0xcf, 0x7f, 0xef, 0x7b, 0xff, 0x79, 0xff, 0x78, 0x7e, 0x3c, 0xfe, 0x3f,
   0xfc, 0x1f, 0xf8, 0x0f, 0xe0, 0x03, 0x00, 0x00};

/*-------------------------------------------------------------------
 *	Data Drags: Operation Cursors
 *-------------------------------------------------------------------*/

/*	
 *	Data: Operation Move
 */

#define data_move_width 16
#define data_move_height 16

static unsigned char data_move_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char data_move_m_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/*	
 *	Data: Operation Copy
 */

#define data_copy_width 16
#define data_copy_height 16

static unsigned char data_copy_bits[] = {
   0x00, 0x00, 0xfe, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x1f, 0x02, 0x11,
   0x02, 0x11, 0x02, 0x11, 0x02, 0x11, 0x02, 0x11, 0xfe, 0x11, 0x20, 0x10,
   0x20, 0x10, 0xe0, 0x1f, 0x00, 0x00, 0x00, 0x00};

static unsigned char data_copy_m_bits[] = {
   0xff, 0x03, 0xff, 0x03, 0xff, 0x03, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0x3f,
   0xff, 0x3f, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0x3f,
   0xf0, 0x3f, 0xf0, 0x3f, 0xf0, 0x3f, 0x00, 0x00};

/*	
 *	Data: Operation Link
 */

#define data_link_width 16
#define data_link_height 16

static unsigned char data_link_bits[] = {
   0x00, 0x00, 0xfe, 0x03, 0x02, 0x02, 0x02, 0x02, 0x32, 0x02, 0x32, 0x3e,
   0x42, 0x20, 0x82, 0x20, 0x02, 0x21, 0x3e, 0x26, 0x20, 0x26, 0x20, 0x20,
   0x20, 0x20, 0xe0, 0x3f, 0x00, 0x00, 0x00, 0x00};

static unsigned char data_link_m_bits[] = {
   0xff, 0x07, 0xff, 0x07, 0xff, 0x07, 0xff, 0x07, 0xff, 0x7f, 0xff, 0x7f,
   0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xf0, 0x7f,
   0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0x00, 0x00};

/*-------------------------------------------------------------------
 *	Data Drags: Source Icons
 *-------------------------------------------------------------------*/

/*
 *	Data Source: Single
 */

#define data_single_width 32
#define data_single_height 32

static unsigned char data_single_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x7f, 0x00, 0x10, 0x00, 0xc0, 0x00,
   0x10, 0x00, 0x40, 0x01, 0x10, 0x00, 0x40, 0x02, 0x10, 0x00, 0x40, 0x04,
   0x10, 0x00, 0xc0, 0x0f, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x0f};

static unsigned char data_single_m_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x7f, 0x00, 0xf0, 0xff, 0xff, 0x00,
   0xf0, 0xff, 0xff, 0x01, 0xf0, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0x07,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f,
   0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x0f};

/*
 *	Data Source: Multiple 
 */

#define data_multiple_width 32
#define data_multiple_height 32

static unsigned char data_multiple_bits[] = {
   0xfc, 0xff, 0x0f, 0x00, 0x04, 0x00, 0x30, 0x00, 0x04, 0x00, 0xd0, 0x1f,
   0x04, 0x00, 0x90, 0x10, 0x04, 0x00, 0x10, 0xf1, 0x04, 0x00, 0xf0, 0x93,
   0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92,
   0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92,
   0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92,
   0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92,
   0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92,
   0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92,
   0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92, 0x04, 0x00, 0x00, 0x92,
   0xfc, 0xff, 0xff, 0x93, 0x20, 0x00, 0x00, 0x90, 0xe0, 0xff, 0xff, 0x9f,
   0x00, 0x01, 0x00, 0x80, 0x00, 0xff, 0xff, 0xff};

static unsigned char data_multiple_m_bits[] = {
   0xfc, 0xff, 0x0f, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0xfc, 0xff, 0xff, 0x1f,
   0xfc, 0xff, 0xff, 0x1f, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
   0xfc, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff,
   0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff};

#ifdef __cplusplus
}
#endif

#endif /* _Dt_DndIconI_h */
