/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define(function (require, exports, module) {
    "use strict";

    require("spec/Async-test");
    require("spec/CodeHint-test");
    require("spec/CodeHintUtils-test");
    require("spec/CodeInspection-test");
    require("spec/CommandManager-test");
    require("spec/CSSUtils-test");
    require("spec/CSSInlineEdit-test");
    require("spec/JSUtils-test");
    require("spec/Document-test");
    require("spec/DocumentCommandHandlers-test");
    require("spec/DocumentManager-test");
    require("spec/DragAndDrop-test");
    require("spec/Editor-test");
    require("spec/EditorRedraw-test");
    require("spec/EditorCommandHandlers-test");
    require("spec/EditorOptionHandlers-test");
    require("spec/EditorManager-test");
    require("spec/EventDispatcher-test");
    require("spec/ExtensionInstallation-test");
    require("spec/ExtensionLoader-test");
    require("spec/ExtensionManager-test");
    require("spec/ExtensionUtils-test");
    require("spec/FileFilters-test");
    require("spec/FileSystem-test");
    require("spec/FileTreeView-test");
    require("spec/FileTreeViewModel-test");
    require("spec/FileUtils-test");
    require("spec/FindInFiles-test");
    require("spec/FindReplace-test");
    require("spec/HTMLInstrumentation-test");
    require("spec/HTMLSimpleDOM-test");
    require("spec/HTMLTokenizer-test");
    require("spec/InlineEditorProviders-test");
    require("spec/InstallExtensionDialog-test");
    require("spec/JSONUtils-test");
    require("spec/KeyBindingManager-test");
    require("spec/LanguageManager-test");
    require("spec/LanguageTools-test");
    require("spec/LiveDevelopment-test");
    require("spec/LiveDevelopmentMultiBrowser-test");
    require("spec/LowLevelFileIO-test");
    require("spec/MainViewFactory-test");
    require("spec/MainViewManager-test");
    require("spec/Menu-test");
    require("spec/MultiRangeInlineEditor-test");
    require("spec/NativeMenu-test");
    require("spec/NodeConnection-test");
    require("spec/Pane-test");
    require("spec/PreferencesBase-test");
    require("spec/PreferencesManager-test");
    require("spec/ProjectManager-test");
    require("spec/ProjectModel-test");
    require("spec/QuickOpen-test");
    require("spec/QuickSearchField-test");
    require("spec/RemoteFunctions-test");
    require("spec/SpecRunnerUtils-test");
    require("spec/StringMatch-test");
    require("spec/StringUtils-test");
    require("spec/TextRange-test");
    require("spec/ThemeManager-test");
    require("spec/UpdateNotification-test");
    require("spec/UrlParams-test");
    require("spec/ValidationUtils-test");
    require("spec/ViewFactory-test");
    require("spec/ViewCommandHandlers-test");
    require("spec/ViewUtils-test");
    require("spec/WorkingSetView-test");
    require("spec/WorkingSetSort-test");
    require("spec/XMLUtils-test");
});
