/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define({

    /**
     * Errors
     */

    // General file io error strings
    "GENERIC_ERROR"                     : "(błąd {0})",
    "NOT_FOUND_ERR"                     : "Nie znaleziono pliku/folderu.",
    "NOT_READABLE_ERR"                  : "Nie można odczytać pliku/folderu.",
    "EXCEEDS_MAX_FILE_SIZE"             : "Pliki większe niż {0} MB nie mogą być otwarte w {APP_NAME}.",
    "NO_MODIFICATION_ALLOWED_ERR"       : "Nie można zmodyfikować folderu docelowego.",
    "NO_MODIFICATION_ALLOWED_ERR_FILE"  : "Nie masz uprawnień by modyfikować ten plik.",
    "CONTENTS_MODIFIED_ERR"             : "Plik został zmodyfikowany poza {APP_NAME}.",
    "UNSUPPORTED_ENCODING_ERR"          : "{APP_NAME} aktualnie wspiera tylko pliki tekstowe z kodowaniem UTF-8.",
    "FILE_EXISTS_ERR"                   : "Plik lub folder już istnieje.",
    "FILE"                              : "plik",
    "FILE_TITLE"                        : "Plik",
    "DIRECTORY"                         : "folder",
    "DIRECTORY_TITLE"                   : "Folder",
    "DIRECTORY_NAMES_LEDE"              : "Nazwy folderów",
    "FILENAMES_LEDE"                    : "Nazwy plików",
    "FILENAME"                          : "Nazwa pliku",
    "DIRECTORY_NAME"                    : "Nazwa folderu",

    // Project error strings
    "ERROR_LOADING_PROJECT"             : "Błąd podczas ładowania projektu",
    "OPEN_DIALOG_ERROR"                 : "Wystąpił błąd podczas wyświetlania okna otwierania pliku. (błąd {0})",
    "REQUEST_NATIVE_FILE_SYSTEM_ERROR"  : "Wystąpił błąd przy próbie otwarcia folderu <span class='dialog-filename'>{0}</span>. (błąd {1})",
    "READ_DIRECTORY_ENTRIES_ERROR"      : "Wystąpił błąd podczas odczytu zawartości folderu <span class='dialog-filename'>{0}</span>. (błąd {1})",

    // File open/save error string
    "ERROR_OPENING_FILE_TITLE"          : "Błąd podczas otwarcia pliku",
    "ERROR_OPENING_FILE"                : "Wystąpił błąd podczas próby otwarcia pliku <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_OPENING_FILES"               : "Wystąpił błąd podczas otwierania plików:",
    "ERROR_RELOADING_FILE_TITLE"        : "Błąd podczas przeładowania zmian z dysku",
    "ERROR_RELOADING_FILE"              : "Błąd podczas przeładowania pliku <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_SAVING_FILE_TITLE"           : "Problem z zapisaniem pliku",
    "ERROR_SAVING_FILE"                 : "Błąd podczas próby zapisu pliku <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_FILE_TITLE"         : "Błąd podczas zmiany nazwy pliku {0}",
    "ERROR_RENAMING_FILE"               : "Błąd podczas próby zmiany nazwy pliku {2} <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_NOT_IN_PROJECT"     : "Plik lub folder nie jest częścią aktualnie otwartego projektu. Niestety, w tym momencie możesz zmienić nazwę tylko dla plików projektu.",
    "ERROR_DELETING_FILE_TITLE"         : "Błąd podczas usuwania pliku {0}",
    "ERROR_DELETING_FILE"               : "Błąd podczas próby usunięcia {2} <span class='dialog-filename'>{0}</span>. {1}",
    "INVALID_FILENAME_TITLE"            : "Nieprawidłowa nazwa pliku {0}",
    "INVALID_FILENAME_MESSAGE"          : "{0} nie może kończyć się kropką (.), zawierać żadnych zarezerwowanych słów ani żadnych z tych znaków: <code class='emphasized'>{1}</code>",
    "ENTRY_WITH_SAME_NAME_EXISTS"       : "Plik lub folder o nazwie <span class='dialog-filename'>{0}</span> już istnieje.",
    "ERROR_CREATING_FILE_TITLE"         : "Nie można utworzyć pliku {0}",
    "ERROR_CREATING_FILE"               : "Błąd podczas próby stworzenia pliku {0} <span class='dialog-filename'>{1}</span>. {2}",
    "ERROR_MIXED_DRAGDROP"              : "Nie można otworzyć folderu podczas otwierana innych plików.",

    // User key map error strings
    "ERROR_KEYMAP_TITLE"                : "Błąd podczas odczytywania konfiguracji klawiszy",
    "ERROR_KEYMAP_CORRUPT"              : "Twój plik z konfiguracją klawiszy nie jest poprawnie zakodowanym plikiem JSON. Zostanie on otwarty abyś mógł go poprawić.",
    "ERROR_LOADING_KEYMAP"              : "Twój plik z konfiguracją klawiszy nie jest poprawnie zakodowanym plikiem UTF-8 i nie może zostać załadowany.",
    "ERROR_RESTRICTED_COMMANDS"         : "Nie możesz nadpisać skrótów do tych komend: {0}",
    "ERROR_RESTRICTED_SHORTCUTS"        : "Nie możesz nadpisać tych skrótów: {0}",
    "ERROR_MULTIPLE_SHORTCUTS"          : "Próbujesz przypisać kilka skrótów do następujących komend: {0}",
    "ERROR_DUPLICATE_SHORTCUTS"         : "Upewnij się, że następujące skróty są unikalne (nie nadpisują się): {0}",
    "ERROR_INVALID_SHORTCUTS"           : "Podane skróty są nieprawidłowe: {0}",
    "ERROR_NONEXISTENT_COMMANDS"        : "Próbujesz przypisać skróty do niestniejących komend: {0}",

    // Application preferences corrupt error strings
    "ERROR_PREFS_CORRUPT_TITLE"         : "Błąd podczas wczytywania ustawień",
    "ERROR_PREFS_CORRUPT"               : "Twój plik ustawień nie jest poprawnie zakodowanym plikiem JSON. Zostanie on otwarty abyś mógł go poprawić. Aby zastosować zmiany, uruchom ponownie {APP_NAME}.",
    "ERROR_PROJ_PREFS_CORRUPT"          : "Twój plik ustawień projektu nie jest poprawnie zakodowanym plikiem JSON. Zostanie on otwarty abyś mógł go poprawić. Aby zastosować zmiany, musisz przeładować projekt.",

    // Application error strings
    "ERROR_IN_BROWSER_TITLE"            : "Oops! {APP_NAME} nie działa jeszcze w przeglądarkach.",
    "ERROR_IN_BROWSER"                  : "{APP_NAME} został zbudowany w HTML, jednak na razie działa jako samodzielna aplikacja. Możesz użyć jej do edycji plików na dysku. Aby uruchomić {APP_NAME} użyj aplikacji dostępnej pod adresem <b>github.com/adobe/brackets-shell</b>.",

    // ProjectManager max files error string
    "ERROR_MAX_FILES_TITLE"             : "Błąd podczas indeksowania plików",
    "ERROR_MAX_FILES"                   : "Ten projekt zawiera więcej niż 30.000 plików. Funkcje, które pracują na wielu plikach mogą być wyłączone lub zachowywać się tak, jakby projekt był pusty. <a href='https://github.com/adobe/brackets/wiki/Large-Projects'>Przeczytaj więcej nt. pracy z dużymi projektami</a>.",

    // Live Preview error strings
    "ERROR_LAUNCHING_BROWSER_TITLE"     : "Błąd podczas uruchamiania przeglądarki",
    "ERROR_CANT_FIND_CHROME"            : "Nie znaleziono przeglądarki Google Chrome. Upewnij się, że jest zainstalowana.",
    "ERROR_LAUNCHING_BROWSER"           : "Błąd podczas uruchamiania przeglądarki. (błąd {0})",

    "LIVE_DEVELOPMENT_ERROR_TITLE"      : "Błąd podglądu na żywo",
    "LIVE_DEVELOPMENT_RELAUNCH_TITLE"   : "Łączenie z przeglądarką",
    "LIVE_DEVELOPMENT_ERROR_MESSAGE"    : "Aby podgląd na żywo mógł się połączyć, Chrome musi zostać zrestartowany z włączonym zdalnym debugowaniem.<br /><br />Czy chcesz zrestartować Chrome i uaktywnić zdalne debugowanie?<br /><br />",
    "LIVE_DEV_LOADING_ERROR_MESSAGE"    : "Nie można wczytać strony podglądu na żywo.",
    "LIVE_DEV_NEED_HTML_MESSAGE"        : "Aby uruchomić podgląd na żywo, otwórz plik HTML lub upewnij się, że w Twoim projekcie jest plik index.html.",
    "LIVE_DEV_NEED_BASEURL_MESSAGE"     : "Aby uruchomić podgląd na żywo na plikach serwerowych, musisz podać główny adres dla tego projektu (Base URL).",
    "LIVE_DEV_SERVER_NOT_READY_MESSAGE" : "Błąd przy próbie uruchomienia serwera HTTP dla podglądu na żywo. Spróbuj ponownie.",
    "LIVE_DEVELOPMENT_INFO_TITLE"       : "Witaj w podglądzie na żywo (Live Preview)!",
    "LIVE_DEVELOPMENT_INFO_MESSAGE"     : "Podgląd na żywo został podłączony do twojej przeglądarki. Umożliwia on podgląd twojego pliku HTML w przeglądarce oraz aktualizuje go za każdym razem, gdy edytujesz swój kod.<br /><br />W aktualnej wersji {APP_NAME}, podgląd na żywo działa tylko w <strong>Google Chrome</strong> i aktualizuje w czasie rzeczywistym <strong>pliki CSS lub HTML</strong>. Zmiany w JavaScript są automatycznie odświeżane po zapisie pliku.<br /><br />(Zobaczysz tę wiadomość tylko raz.)",
    "LIVE_DEVELOPMENT_TROUBLESHOOTING"  : "Więcej informacji znajdziesz na stronie <a href='{0}' title='{0}'>Troubleshooting Live Preview connection errors</a>.",

    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED" : "Podgląd na żywo",
    "LIVE_DEV_STATUS_TIP_PROGRESS1"     : "Podgląd na żywo: łączenie\u2026",
    "LIVE_DEV_STATUS_TIP_PROGRESS2"     : "Podgląd na żywo: inicjalizacja\u2026",
    "LIVE_DEV_STATUS_TIP_CONNECTED"     : "Rozłącz podgląd na żywo",
    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC"   : "Podgląd na żywo (zapisz plik by odświeżyć)",
    "LIVE_DEV_STATUS_TIP_SYNC_ERROR"    : "Podgląd na żywo (bez odświeżania - wystąpiły błędy składniowe)",

    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS" : "Podgląd na żywo został wyłączony, ponieważ uruchomiono narzędzia dla programistów w przeglądarce",
    "LIVE_DEV_DETACHED_TARGET_CLOSED"          : "Podgląd na żywo został wyłączony, ponieważ strona została zamknięta w przeglądarce",
    "LIVE_DEV_NAVIGATED_AWAY"                  : "Podgląd na żywo został wyłączony, ponieważ została załadowana strona nie należąca do aktualnego projektu",
    "LIVE_DEV_CLOSED_UNKNOWN_REASON"           : "Podgląd na żywo został wyłączony z nieznanego powodu ({0})",

    "SAVE_CLOSE_TITLE"                  : "Zapisz zmiany",
    "SAVE_CLOSE_MESSAGE"                : "Czy chcesz zapisać zmiany w dokumencie <span class='dialog-filename'>{0}</span>?",
    "SAVE_CLOSE_MULTI_MESSAGE"          : "Czy chcesz zapisać zmiany w następujących plikach?",
    "EXT_MODIFIED_TITLE"                : "Zmiany zewnętrzne",
    "CONFIRM_DELETE_TITLE"              : "Potwierdź usunięcie",
    "CONFIRM_FILE_DELETE"               : "Czy na pewno chcesz usunąć plik <span class='dialog-filename'>{0}</span>?",
    "CONFIRM_FOLDER_DELETE"             : "Czy na pewno chcesz usunąć folder <span class='dialog-filename'>{0}</span>?",
    "FILE_DELETED_TITLE"                : "Plik został usunięty",
    "EXT_MODIFIED_WARNING"              : "<span class='dialog-filename'>{0}</span> został zmodyfikowany na dysku, poza {APP_NAME}.<br /><br />Czy chcesz zapisać plik i nadpisać te zmiany?",
    "EXT_MODIFIED_MESSAGE"              : "<span class='dialog-filename'>{0}</span> został zmodyfikowany na dysku, poza {APP_NAME}, ale zawiera też niezapisane zmiany w {APP_NAME}.<br /><br />Którą wersję chcesz zachować?",
    "EXT_DELETED_MESSAGE"               : "<span class='dialog-filename'>{0}</span> został usunięty z dysku, ale zawiera niezapisane zmiany w {APP_NAME}.<br /><br />Czy chcesz zachować te zmiany?",

    // Generic dialog/button labels
    "DONE"                              : "Gotowe",
    "OK"                                : "OK",
    "CANCEL"                            : "Anuluj",
    "DONT_SAVE"                         : "Nie zapisuj",
    "SAVE"                              : "Zapisz",
    "SAVE_AS"                           : "Zapisz jako\u2026",
    "SAVE_AND_OVERWRITE"                : "Nadpisz",
    "DELETE"                            : "Usuń",
    "BUTTON_YES"                        : "Tak",
    "BUTTON_NO"                         : "Nie",

    // Find, Replace, Find in Files
    "FIND_MATCH_INDEX"                  : "{0} z {1}",
    "FIND_NO_RESULTS"                   : "Brak wyników",
    "FIND_QUERY_PLACEHOLDER"            : "Szukaj\u2026",
    "FIND_HISTORY_MAX_COUNT"            : "Maksymalna liczba pozycji w historii wyszukiwania",
    "REPLACE_PLACEHOLDER"               : "Zamień na\u2026",
    "BUTTON_REPLACE_ALL"                : "Zamień wiele\u2026",
    "BUTTON_REPLACE_BATCH"              : "Przetwarzaj\u2026",
    "BUTTON_REPLACE_ALL_IN_FILES"       : "Zamień w wielu plikach\u2026",
    "BUTTON_REPLACE"                    : "Zamień",
    "BUTTON_NEXT"                       : "\u25B6",
    "BUTTON_PREV"                       : "\u25C0",
    "BUTTON_NEXT_HINT"                  : "Następna reguła",
    "BUTTON_PREV_HINT"                  : "Poprzednia reguła",
    "BUTTON_CASESENSITIVE_HINT"         : "Weź pod uwagę wielkie i małe litery",
    "BUTTON_REGEXP_HINT"                : "Wyrażenie regularne",
    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Zamień bez cofania",
    "REPLACE_WITHOUT_UNDO_WARNING"      : "Ponieważ więcej niż {0} plików wymaga zmiany, {APP_NAME} zmodyfikuje pliki na dysku, które nie są otwarte.<br />Nie będziesz możlwiości cofnięcia nadpisanych zmian w tych plikach.",
    "BUTTON_REPLACE_WITHOUT_UNDO"       : "Zamień bez cofania",

    "OPEN_FILE"                         : "Otwórz plik",
    "SAVE_FILE_AS"                      : "Zapisz plik",
    "CHOOSE_FOLDER"                     : "Wybierz folder",

    "RELEASE_NOTES"                     : "Informacje o wydaniu",
    "NO_UPDATE_TITLE"                   : "{APP_NAME} jest aktualny!",
    "NO_UPDATE_MESSAGE"                 : "Aktualnie używasz najnowszej wersji {APP_NAME}.",

    // Find and Replace
    "FIND_REPLACE_TITLE_LABEL"          : "Zamień",
    "FIND_REPLACE_TITLE_WITH"           : "z",
    "FIND_TITLE_LABEL"                  : "Znaleziono",
    "FIND_TITLE_SUMMARY"                : "&mdash; {0} {1} {2} w {3}",

    // Find in Files
    "FIND_NUM_FILES"                    : "{0} {1}",
    "FIND_IN_FILES_SCOPED"              : "w <span class='dialog-filename'>{0}</span>",
    "FIND_IN_FILES_NO_SCOPE"            : "w projekcie",
    "FIND_IN_FILES_ZERO_FILES"          : "Filtr wyklucza wszystkie pliki {0}",
    "FIND_IN_FILES_FILE"                : "plik",
    "FIND_IN_FILES_FILES"               : "pliki",
    "FIND_IN_FILES_MATCH"               : "dopasowanie",
    "FIND_IN_FILES_MATCHES"             : "dopasowania",
    "FIND_IN_FILES_MORE_THAN"           : "Więcej niż ",
    "FIND_IN_FILES_PAGING"              : "{0}&mdash;{1}",
    "FIND_IN_FILES_FILE_PATH"           : "<span class='dialog-filename'>{0}</span> {2} <span class='dialog-path'>{1}</span>", // We should use normal dashes on Windows instead of em dash eventually
    "FIND_IN_FILES_EXPAND_COLLAPSE"     : "Naciśnij Ctrl/Cmd by rozwinąć/zwinąć wszystkie",
    "FIND_IN_FILES_INDEXING"            : "Indeksowanie do natychmiastowego wyszukiwania\u2026",
    "REPLACE_IN_FILES_ERRORS_TITLE"     : "Zamień błędy",
    "REPLACE_IN_FILES_ERRORS"           : "Poniższe pliki nie zostały zmienione, ponieważ ich treść zmieniła się po zakończeniu wyszukiwania lub nie mogły być zapisane.",

    "ERROR_FETCHING_UPDATE_INFO_TITLE"  : "Błąd podczas pobierania informacji o aktualizacjach",
    "ERROR_FETCHING_UPDATE_INFO_MSG"    : "Wystąpił problem podczas pobierania informacji o najnowszej wersji aplikacji. Upewnij się, że masz połączenie z internetem i spróbuj ponownie",

    // File exclusion filters
    "NEW_FILE_FILTER"                   : "Nowy filtr\u2026",
    "CLEAR_FILE_FILTER"                 : "Nie wykluczaj plików",
    "NO_FILE_FILTER"                    : "Brak wykluczonych plików",
    "EXCLUDE_FILE_FILTER"               : "Wyklucz {0}",
    "EDIT_FILE_FILTER"                  : "Edytuj\u2026",
    "FILE_FILTER_DIALOG"                : "Edytuj wykluczenia",
    "FILE_FILTER_INSTRUCTIONS"          : "Wyklucz pliki/foldery pasujące do następujących nazw, wzorów lub <a href='{0}' title='{0}'>masek</a>. Każdą regułę umieść w osobnej linii.",
    "FILTER_NAME_PLACEHOLDER"           : "Nazwa wykluczenia (opcjonalnie)",
    "FILTER_NAME_REMAINING"             : "pozostało {0} znaków",
    "FILE_FILTER_CLIPPED_SUFFIX"        : "i {0} więcej",
    "FILTER_COUNTING_FILES"             : "Liczenie plików\u2026",
    "FILTER_FILE_COUNT"                 : "Przeszukane zostanie {0} z {1} plików {2}",
    "FILTER_FILE_COUNT_ALL"             : "Przeszukane zostanie wszystkie {0} plików {1}",

    // Quick Edit
    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND"   : "Nie można użyć szybkiej edycji w tym miejscu",
    "ERROR_CSSQUICKEDIT_BETWEENCLASSES"     : "Szybka edycja CSS: zaznacz kursorem pojedynczą nazwę klasy",
    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND"      : "Szybka edycja CSS: niekompletny atrybut class",
    "ERROR_CSSQUICKEDIT_IDNOTFOUND"         : "Szybka edycja CSS: niekompletny atrybut id",
    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR"    : "Szybka edycja CSS: zaznacz kursorem tag, klasę lub id",
    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX"   : "Szybka edycja funkcji czasowych CSS: nieprawidłowa składnia",
    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND"    : "Szybka edycja JS: zaznacz kursorem nazwę funkcji",

    // Quick Docs
    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND"   : "Nie znaleziono dokumentacji dla tego elementu.",

    /**
     * ProjectManager
     */
    "PROJECT_LOADING"   : "Ładowanie\u2026",
    "UNTITLED"          : "Bez tytułu",
    "WORKING_FILES"     : "Otwarte pliki",

    /**
     * MainViewManager
     */
    "TOP"               : "Panel górny",
    "BOTTOM"            : "Panel dolny",
    "LEFT"              : "Panel lewy",
    "RIGHT"             : "Panel prawy",

    "CMD_SPLITVIEW_NONE"        : "Bez podziału",
    "CMD_SPLITVIEW_VERTICAL"    : "Podziel pionowo",
    "CMD_SPLITVIEW_HORIZONTAL"  : "Podziel poziomo",
    "SPLITVIEW_MENU_TOOLTIP"    : "Podziel edytor pionowo lub poziomo",
    "GEAR_MENU_TOOLTIP"         : "Uporządkuj pliki",

    "SPLITVIEW_INFO_TITLE"              : "Plik jest już otwarty",
    "SPLITVIEW_MULTIPANE_WARNING"       : "Plik jest już otwarty w innym panelu. {APP_NAME} niedługo będzie pozwalał otwierać ten sam plik w wielu panelach. Do tego czasu plik będzie widoczny w panelu, w którym już jest otwarty.<br /><br />(Tę wiadomość zobaczysz tylko raz)",

    /**
     * Keyboard modifiers and special key names
     */
    "KEYBOARD_CTRL"         : "Ctrl",
    "KEYBOARD_SHIFT"        : "Shift",
    "KEYBOARD_SPACE"        : "Space",
    "KEYBOARD_PAGE_UP"      : "Page Up",
    "KEYBOARD_PAGE_DOWN"    : "Page Down",
    "KEYBOARD_HOME"         : "Home",
    "KEYBOARD_END"          : "End",
    "KEYBOARD_INSERT"       : "Insert",
    "KEYBOARD_DELETE"       : "Delete",

    /**
     * StatusBar strings
     */
    "STATUSBAR_CURSOR_POSITION"             : "linia {0}, kolumna {1}",
    "STATUSBAR_SELECTION_CH_SINGULAR"       : " \u2014 Zaznaczono {0} kolumnę",
    "STATUSBAR_SELECTION_CH_PLURAL"         : " \u2014 Zaznaczono {0} kolumn",
    "STATUSBAR_SELECTION_LINE_SINGULAR"     : " \u2014 Zaznaczono {0} linię",
    "STATUSBAR_SELECTION_LINE_PLURAL"       : " \u2014 Zaznaczono {0} linii",
    "STATUSBAR_SELECTION_MULTIPLE"          : " \u2014 {0} zaznaczeń",
    "STATUSBAR_INDENT_TOOLTIP_SPACES"       : "Kliknij, by zamienić wcięcia na spacje",
    "STATUSBAR_INDENT_TOOLTIP_TABS"         : "Kliknij, by zamienić wcięcia na tabulacje",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES"  : "Kliknij, by zmienić ilość spacji we wcięciu",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS"    : "Kliknij, by zmienić wielkość tabulacji",
    "STATUSBAR_SPACES"                      : "Spacje:",
    "STATUSBAR_TAB_SIZE"                    : "Tabulacje:",
    "STATUSBAR_LINE_COUNT_SINGULAR"         : "\u2014 {0} linia",
    "STATUSBAR_LINE_COUNT_PLURAL"           : "\u2014 {0} linii",
    "STATUSBAR_USER_EXTENSIONS_DISABLED"    : "Rozszerzenia wyłączone",
    "STATUSBAR_INSERT"                      : "INS",
    "STATUSBAR_OVERWRITE"                   : "OVR",
    "STATUSBAR_INSOVR_TOOLTIP"              : "Kliknij aby zmienić tryb wprowadzania: wstaw (INS) lub zastąp (OVR)",
    "STATUSBAR_LANG_TOOLTIP"                : "Kliknij aby zmienić rodzaj pliku (podświetlanie składni)",
    "STATUSBAR_CODE_INSPECTION_TOOLTIP"     : "{0}. Naciśnij aby włączyć/wyłączyć panel raportów.",
    "STATUSBAR_DEFAULT_LANG"                : "(domyślny)",
    "STATUSBAR_SET_DEFAULT_LANG"            : "Ustaw domyślny dla plików .{0}",

    // CodeInspection: errors/warnings
    "ERRORS_PANEL_TITLE_MULTIPLE"           : "{0} problemów",
    "SINGLE_ERROR"                          : "1 błąd {0}",
    "MULTIPLE_ERRORS"                       : "{1} błędów {0} ",
    "NO_ERRORS"                             : "Brak błędów {0} – dobra robota!",
    "NO_ERRORS_MULTIPLE_PROVIDER"           : "Brak błędów - dobra robota!",
    "LINT_DISABLED"                         : "Linting jest wyłączony.",
    "NO_LINT_AVAILABLE"                     : "Żaden linter nie jest dostępny dla {0}",
    "NOTHING_TO_LINT"                       : "Brak plików do sprawdzenia.",
    "LINTER_TIMED_OUT"                      : "{0} przekroczył limit czasu, czekał {1} ms",
    "LINTER_FAILED"                         : "{0} zakończył z błędem: {1}",

    /**
     * Command Name Constants
     */

    // File menu commands
    "FILE_MENU"                           : "Plik",
    "CMD_FILE_NEW_UNTITLED"               : "Nowy",
    "CMD_FILE_NEW"                        : "Nowy plik",
    "CMD_FILE_NEW_FOLDER"                 : "Nowy folder",
    "CMD_FILE_OPEN"                       : "Otwórz\u2026",
    "CMD_RECENT_FILES_OPEN"               : "Ostatnio otwierane\u2026",
    "CMD_ADD_TO_WORKING_SET"              : "Dodaj do folderu roboczego",
    "CMD_OPEN_DROPPED_FILES"              : "Otwórz przeciągnięte pliki",
    "CMD_OPEN_FOLDER"                     : "Otwórz folder\u2026",
    "CMD_FILE_CLOSE"                      : "Zamknij",
    "CMD_FILE_CLOSE_ALL"                  : "Zamknij wszystko",
    "CMD_FILE_CLOSE_LIST"                 : "Zamknij listę",
    "CMD_FILE_CLOSE_OTHERS"               : "Zamknij inne",
    "CMD_FILE_CLOSE_ABOVE"                : "Zamknij pliki powyżej",
    "CMD_FILE_CLOSE_BELOW"                : "Zamknij pliki poniżej",
    "CMD_FILE_SAVE"                       : "Zapisz",
    "CMD_FILE_SAVE_ALL"                   : "Zapisz wszystko",
    "CMD_FILE_SAVE_AS"                    : "Zapisz jako\u2026",
    "CMD_LIVE_FILE_PREVIEW"               : "Podgląd na żywo",
    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE"     : "Podgląd na żywo (eksperymentalny)",
    "CMD_RELOAD_LIVE_PREVIEW"             : "Wymuś przeładowanie podglądu na żywo",
    "CMD_PROJECT_SETTINGS"                : "Ustawienia projektu\u2026",
    "CMD_FILE_RENAME"                     : "Zmień nazwę",
    "CMD_FILE_DELETE"                     : "Usuń",
    "CMD_INSTALL_EXTENSION"               : "Zainstaluj rozszerzenie\u2026",
    "CMD_EXTENSION_MANAGER"               : "Menedżer rozszerzeń\u2026",
    "CMD_FILE_REFRESH"                    : "Odśwież",
    "CMD_QUIT"                            : "Wyjdź",
    // Used in native File menu on Windows
    "CMD_EXIT"                            : "Wyjdź",

    // Edit menu commands
    "EDIT_MENU"                           : "Edytuj",
    "CMD_UNDO"                            : "Cofnij",
    "CMD_REDO"                            : "Ponów",
    "CMD_CUT"                             : "Wytnij",
    "CMD_COPY"                            : "Kopiuj",
    "CMD_PASTE"                           : "Wklej",
    "CMD_SELECT_ALL"                      : "Zaznacz wszystko",
    "CMD_SELECT_LINE"                     : "Zaznacz linię",
    "CMD_SPLIT_SEL_INTO_LINES"            : "Podziel zaznaczenie na linie",
    "CMD_ADD_CUR_TO_NEXT_LINE"            : "Dodaj kursor do następnej linii",
    "CMD_ADD_CUR_TO_PREV_LINE"            : "Dodaj kursor do poprzedniej linii",
    "CMD_INDENT"                          : "Dodaj wcięcie",
    "CMD_UNINDENT"                        : "Cofnij wcięcie",
    "CMD_DUPLICATE"                       : "Duplikuj",
    "CMD_DELETE_LINES"                    : "Usuń linię",
    "CMD_COMMENT"                         : "Komentarz liniowy",
    "CMD_BLOCK_COMMENT"                   : "Komentarz blokowy",
    "CMD_LINE_UP"                         : "Przenieś linię wyżej",
    "CMD_LINE_DOWN"                       : "Przenieś linię niżej",
    "CMD_OPEN_LINE_ABOVE"                 : "Otwórz linię wyżej",
    "CMD_OPEN_LINE_BELOW"                 : "Otwórz linię niżej",
    "CMD_TOGGLE_CLOSE_BRACKETS"           : "Automatycznie zamykaj nawiasy",
    "CMD_SHOW_CODE_HINTS"                 : "Pokaż podpowiedź",

    // Search menu commands
    "FIND_MENU"                           : "Szukaj",
    "CMD_FIND"                            : "Znajdź",
    "CMD_FIND_NEXT"                       : "Znajdź następny",
    "CMD_FIND_PREVIOUS"                   : "Znajdź poprzedni",
    "CMD_FIND_ALL_AND_SELECT"             : "Znajdź wszystkie i zaznacz",
    "CMD_ADD_NEXT_MATCH"                  : "Dodaj następny wynik do zaznaczenia",
    "CMD_SKIP_CURRENT_MATCH"              : "Pomiń i dodaj następny wynik",
    "CMD_FIND_IN_FILES"                   : "Szukaj w plikach",
    "CMD_FIND_IN_SUBTREE"                 : "Szukaj w\u2026",
    "CMD_REPLACE"                         : "Zamień",
    "CMD_REPLACE_IN_FILES"                : "Zamień w plikach",
    "CMD_REPLACE_IN_SUBTREE"              : "Zamień w\u2026",

    // View menu commands
    "VIEW_MENU"                           : "Widok",
    "CMD_HIDE_SIDEBAR"                    : "Ukryj pasek boczny",
    "CMD_SHOW_SIDEBAR"                    : "Pokaż pasek boczny",
    "CMD_TOGGLE_SIDEBAR"                  : "Przełącz pasek boczny",
    "CMD_TOGGLE_PANELS"                   : "Przełącz panele",
    "CMD_TOGGLE_PURE_CODE"                : "Tryb bez przeszkadzania",
    "CMD_INCREASE_FONT_SIZE"              : "Zwiększ czcionkę",
    "CMD_DECREASE_FONT_SIZE"              : "Zmniejsz czcionkę",
    "CMD_RESTORE_FONT_SIZE"               : "Przywróć domyślny rozmiar czcionki",
    "CMD_SCROLL_LINE_UP"                  : "Przewiń linię wyżej",
    "CMD_SCROLL_LINE_DOWN"                : "Przewiń linię niżej",
    "CMD_TOGGLE_LINE_NUMBERS"             : "Numery linii",
    "CMD_TOGGLE_ACTIVE_LINE"              : "Podświetl aktualną linię",
    "CMD_TOGGLE_WORD_WRAP"                : "Zawijaj wiersze",
    "CMD_LIVE_HIGHLIGHT"                  : "Podświetlaj w podglądzie na żywo",
    "CMD_VIEW_TOGGLE_INSPECTION"          : "Sprawdzaj poprawność plików przy zapisie",
    "CMD_WORKINGSET_SORT_BY_ADDED"        : "Sortuj według dodanych",
    "CMD_WORKINGSET_SORT_BY_NAME"         : "Sortuj według nazwy",
    "CMD_WORKINGSET_SORT_BY_TYPE"         : "Sortuj według typu",
    "CMD_WORKING_SORT_TOGGLE_AUTO"        : "Automatyczne sortowanie",
    "CMD_THEMES"                          : "Motywy\u2026",

    // Navigate menu commands
    "NAVIGATE_MENU"                       : "Nawigacja",
    "CMD_QUICK_OPEN"                      : "Otwórz szybko",
    "CMD_GOTO_LINE"                       : "Przejdź do linii",
    "CMD_GOTO_DEFINITION"                 : "Znajdź szybko definicję",
    "CMD_GOTO_FIRST_PROBLEM"              : "Przejdź do pierwszego błędu",
    "CMD_TOGGLE_QUICK_EDIT"               : "Szybka edycja",
    "CMD_TOGGLE_QUICK_DOCS"               : "Szybka dokumentacja",
    "CMD_QUICK_EDIT_PREV_MATCH"           : "Poprzedni wynik",
    "CMD_QUICK_EDIT_NEXT_MATCH"           : "Następny wynik",
    "CMD_CSS_QUICK_EDIT_NEW_RULE"         : "Nowa reguła",
    "CMD_NEXT_DOC"                        : "Następny dokument",
    "CMD_PREV_DOC"                        : "Poprzedni dokument",
    "CMD_NEXT_DOC_LIST_ORDER"             : "Następny dokument z listy",
    "CMD_PREV_DOC_LIST_ORDER"             : "Poprzedni dokument z listy",
    "CMD_SHOW_IN_TREE"                    : "Pokaż w drzewie katalogów",
    "CMD_SHOW_IN_EXPLORER"                : "Pokaż w eksploratorze",
    "CMD_SHOW_IN_FINDER"                  : "Pokaż w Finder",
    "CMD_SHOW_IN_OS"                      : "Pokaż w systemie plików",
    "CMD_SWITCH_PANE_FOCUS"               : "Zmień aktywny panel",

    // Help menu commands
    "HELP_MENU"                           : "Pomoc",
    "CMD_CHECK_FOR_UPDATE"                : "Sprawdź aktualizacje",
    "CMD_HOW_TO_USE_BRACKETS"             : "Jak używać {APP_NAME}",
    "CMD_SUPPORT"                         : "Wsparcie {APP_NAME}",
    "CMD_SUGGEST"                         : "Zaproponuj swój pomysł",
    "CMD_RELEASE_NOTES"                   : "Informacje o wydaniu",
    "CMD_GET_INVOLVED"                    : "Daj coś od siebie",
    "CMD_SHOW_EXTENSIONS_FOLDER"          : "Otwórz folder z rozszerzeniami",
    "CMD_HEALTH_DATA_STATISTICS"          : "Raportowanie",
    "CMD_HOMEPAGE"                        : "Strona główna {APP_TITLE}",
    "CMD_TWITTER"                         : "{TWITTER_NAME} na Twitterze",
    "CMD_ABOUT"                           : "O programie",
    "CMD_OPEN_PREFERENCES"                : "Otwórz plik z ustawieniami",
    "CMD_OPEN_KEYMAP"                     : "Otwórz plik z konfiguracją klawiszy",

    // Strings for main-view.html
    "EXPERIMENTAL_BUILD"                   : "kompilacja eksperymentalna",
    "RELEASE_BUILD"                        : "kompilacja",
    "DEVELOPMENT_BUILD"                    : "kompilacja rozwojowa",
    "RELOAD_FROM_DISK"                     : "Załaduj z dysku",
    "KEEP_CHANGES_IN_EDITOR"               : "Zachowaj zmiany w edytorze",
    "CLOSE_DONT_SAVE"                      : "Zamknij (nie zapisuj)",
    "RELAUNCH_CHROME"                      : "Zrestartuj Chrome",
    "ABOUT"                                : "O programie",
    "CLOSE"                                : "Zamknij",
    "ABOUT_TEXT_LINE1"                     : "Wydanie {VERSION_MAJOR}.{VERSION_MINOR} {BUILD_TYPE} {VERSION}",
    "ABOUT_TEXT_BUILD_TIMESTAMP"           : "Czas kompilacji: ",
    "ABOUT_TEXT_LINE3"                     : "Uwagi i warunki odnoszące się do oprogramowania firm trzecich znajdują się na: <a href='{ADOBE_THIRD_PARTY}'>{ADOBE_THIRD_PARTY}</a> i zostały dołączone jako odnośnik.",
    "ABOUT_TEXT_LINE4"                     : "Dokumentacja i pliki źródłowe dostępne są pod adresem <a href='https://github.com/adobe/brackets/'>https://github.com/adobe/brackets/</a>",
    "ABOUT_TEXT_LINE5"                     : "Stworzony z \u2764 oraz w JavaScript przez:",
    "ABOUT_TEXT_LINE6"                     : "Mnóstwo ludzi (mamy problemy, by załadować teraz te wszystkie dane).",
    "ABOUT_TEXT_MDN_DOCS"                  : "Dokumentacja MDN oraz logo MDN są objęte licencją Creative Commons Attribution, <a href='{MDN_DOCS_LICENSE}'>CC-BY-SA 2.5 Unported</a>.",
    "UPDATE_NOTIFICATION_TOOLTIP"          : "Dostępna jest nowa wersja {APP_NAME}! Kliknij tutaj i dowiedz się więcej.",
    "UPDATE_AVAILABLE_TITLE"               : "Dostępna nowa aktualizacja",
    "UPDATE_MESSAGE"                       : "Hej, dostępna jest już nowa wersja {APP_NAME}. Oto kilka nowych funkcjonalności:",
    "GET_IT_NOW"                           : "Pobierz teraz!",
    "PROJECT_SETTINGS_TITLE"               : "Ustawienia projektu dla: {0}",
    "PROJECT_SETTING_BASE_URL"             : "Adres podglądu na żywo",
    "PROJECT_SETTING_BASE_URL_HINT"        : "Aby użyć lokalnego serwera, wpisz odpowiedni adres, np. http://localhost:8000/",
    "BASEURL_ERROR_INVALID_PROTOCOL"       : "Protokół {0} nie jest wspierany przez podgląd na żywo&mdash;Użyj http lub https.",
    "BASEURL_ERROR_SEARCH_DISALLOWED"      : "Adres URL nie może zawierać parametrów wyszukiwania takich, jak \"{0}\".",
    "BASEURL_ERROR_HASH_DISALLOWED"        : "Adres URL nie może zawierać znaku hash: \"{0}\".",
    "BASEURL_ERROR_INVALID_CHAR"           : "Znaki specjalne takie, jak '{0}' muszą być zakodowane.",
    "BASEURL_ERROR_UNKNOWN_ERROR"          : "Nieznany błąd podczas parsowania adresu URL",
    
    // Strings for Pane.js
    "EMPTY_VIEW_HEADER"                    : "<em>Kliknij w to okno, a następnie otwórz plik</em>",
    "FLIPVIEW_BTN_TOOLTIP"                 : "Przenieś ten widok do: {0}",

    // Strings for themes-settings.html and themes-general.html
    "CURRENT_THEME"                        : "Aktualny motyw",
    "USE_THEME_SCROLLBARS"                 : "Użyj pasków przewijania z motywu",
    "FONT_SIZE"                            : "Rozmiar czcionki",
    "FONT_FAMILY"                          : "Rodzina czcionek",
    "THEMES_SETTINGS"                      : "Ustawienia motywów",
    
    // CSS Quick Edit
    "BUTTON_NEW_RULE"                      : "Nowa reguła",

    // Extension Management strings
    "INSTALL"                              : "Zainstaluj",
    "UPDATE"                               : "Aktualizuj",
    "REMOVE"                               : "Usuń",
    "DISABLE"                              : "Wyłącz",
    "ENABLE"                               : "Włącz",
    "OVERWRITE"                            : "Nadpisz",
    "CANT_REMOVE_DEV"                      : "Rozszerzenia w folderze \"dev\" muszą być usunięte ręcznie.",
    "CANT_UPDATE"                          : "Aktualizacja nie jest kompatybilna z tą wersją {APP_NAME}.",
    "CANT_UPDATE_DEV"                      : "Rozszerzenia w folderze \"dev\" nie mogą być automatycznie zaktualizowane.",
    "INSTALL_EXTENSION_TITLE"              : "Zainstaluj rozszerzenie",
    "UPDATE_EXTENSION_TITLE"               : "Aktualizuj rozszerzenie",
    "INSTALL_EXTENSION_LABEL"              : "Adres URL rozszerzenia",
    "INSTALL_EXTENSION_HINT"               : "Adres URL pliku zip z rozszerzeniem lub adres repozytorium na GitHub",
    "INSTALLING_FROM"                      : "Instaluję rozszerzenie z {0}\u2026",
    "INSTALL_SUCCEEDED"                    : "Instalacja zakończona!",
    "INSTALL_FAILED"                       : "Instalacja nie powiodła się.",
    "CANCELING_INSTALL"                    : "Anulowanie\u2026",
    "CANCELING_HUNG"                       : "Anulowanie instalacji trwa zbyt długo. Możliwe, że wystąpił błąd wewnętrzny.",
    "INSTALL_CANCELED"                     : "Instalacja anulowana.",
    "VIEW_COMPLETE_DESCRIPTION"            : "Pokaż cały opis",
    "VIEW_TRUNCATED_DESCRIPTION"           : "Pokaż skrócony opis",
    "SORT_EXTENSION_METHOD"                : "Sortuj rozszerzenia według liczby pobrań lub daty publikacji",
    // These must match the error codes in ExtensionsDomain.Errors.* :
    "INVALID_ZIP_FILE"                     : "Pobrany plik nie jest poprawnym plikiem zip.",
    "MISSING_PACKAGE_JSON"                 : "Pakiet nie zawiera pliku package.json.",
    "INVALID_PACKAGE_JSON"                 : "Plik package.json nie jest poprawny (wystąpił błąd: {0}).",
    "MISSING_PACKAGE_NAME"                 : "Plik package.json nie zawiera nazwy pakietu.",
    "BAD_PACKAGE_NAME"                     : "{0} jest niepoprawną nazwą pakietu.",
    "MISSING_PACKAGE_VERSION"              : "Plik package.json nie zawiera wersji pakietu.",
    "INVALID_VERSION_NUMBER"               : "Numer wersji pakietu ({0}) jest niepoprawny.",
    "INVALID_BRACKETS_VERSION"             : "Ciąg kompatybilności z {APP_NAME} ({0}) jest nieprawidłowy.",
    "DISALLOWED_WORDS"                     : "Słowa ({1}) są niedozwolone w polu {0}.",
    "NPM_INSTALL_FAILED"                   : "Nie udało się wykonać polecenia npm install: {0}",
    "API_NOT_COMPATIBLE"                   : "Rozszerzenie nie jest kompatybilne z tą wersją {APP_NAME}. Jest zainstalowane w folderze z nieaktywnymi rozszerzeniami.",
    "MISSING_MAIN"                         : "Pakiet nie zawiera pliku main.js.",
    "EXTENSION_ALREADY_INSTALLED"          : "Zainstalowanie tego rozszerzenia nadpisze to, które zainstalowano poprzednio. Czy nadpisać starsze rozszerzenie?",
    "EXTENSION_SAME_VERSION"               : "To rozszerzenie jest w tej samej wersji, co obecnie zainstalowane. Czy nadpisać zainstalowane rozszerzenie?",
    "EXTENSION_OLDER_VERSION"              : "To rozszerzenie jest w wersji {0}, czyli jest starsze niż obecnie zainstalowane ({1}). Czy nadpisać zainstalowane rozszerzenie?",
    "DOWNLOAD_ID_IN_USE"                   : "Błąd wewnętrzny: taki plik już istnieje.",
    "NO_SERVER_RESPONSE"                   : "Nie można połączyć z serwerem.",
    "BAD_HTTP_STATUS"                      : "Nie znaleziono pliku na serwerze (HTTP {0}).",
    "CANNOT_WRITE_TEMP"                    : "Nie można zapisać pobranego pliku w folderze tymczasowym.",
    "ERROR_LOADING"                        : "Rozszerzenie napotkało błąd podczas uruchamiania.",
    "MALFORMED_URL"                        : "Niepoprawny adres URL. Sprawdź czy został wpisany prawidłowo.",
    "UNSUPPORTED_PROTOCOL"                 : "Adres URL musi zaczynać się od http lub https.",
    "UNKNOWN_ERROR"                        : "Nieznany błąd wewnętrzny.",
    // For NOT_FOUND_ERR, see generic strings above
    "EXTENSION_MANAGER_TITLE"              : "Menedżer rozszerzeń",
    "EXTENSION_MANAGER_ERROR_LOAD"         : "Nie udało się dostać do rejestru rozszerzeń. Spróbuj ponownie później.",
    "INSTALL_EXTENSION_DRAG"               : "Przenieś plik .zip lub",
    "INSTALL_EXTENSION_DROP"               : "Przenieś plik .zip aby zainstalować",
    "INSTALL_EXTENSION_DROP_ERROR"         : "Instalacja/aktualizacja przerwana z powodu błędów:",
    "INSTALL_FROM_URL"                     : "zainstaluj z adresu URL\u2026",
    "INSTALL_EXTENSION_VALIDATING"         : "Sprawdzanie\u2026",
    "EXTENSION_AUTHOR"                     : "Autor",
    "EXTENSION_DATE"                       : "Data",
    "EXTENSION_INCOMPATIBLE_NEWER"         : "To rozszerzenie wymaga nowszej wersji {APP_NAME}.",
    "EXTENSION_INCOMPATIBLE_OLDER"         : "To rozszerzenie działa tylko ze starszymi wersjami {APP_NAME}.",
    "EXTENSION_LATEST_INCOMPATIBLE_NEWER"  : "Wersja {0} tego rozszerzenia wymaga nowszej wersji {APP_NAME}, ale możesz zainstalować starszą wersję {1}.",
    "EXTENSION_LATEST_INCOMPATIBLE_OLDER"  : "Wersja {0} tego rozszerzenia wymaga starszej wersji {APP_NAME}, ale możesz zainstalować starszą wersję {1}.",
    "EXTENSION_NO_DESCRIPTION"             : "Brak opisu",
    "EXTENSION_MORE_INFO"                  : "Więcej informacji\u2026",
    "EXTENSION_ERROR"                      : "Błąd rozszerzenia",
    "EXTENSION_KEYWORDS"                   : "Słowa kluczowe",
    "EXTENSION_TRANSLATED_USER_LANG"       : "Przetłumaczono na {0} języków, w tym twój",
    "EXTENSION_TRANSLATED_GENERAL"         : "Przetłumaczono na {0} języków",
    "EXTENSION_TRANSLATED_LANGS"           : "To rozszerzenie zostało przetłumaczone na języki: {0}",
    "EXTENSION_INSTALLED"                  : "Zainstalowane",
    "EXTENSION_UPDATE_INSTALLED"           : "Aktualizacja rozszerzenia została pobrana i będzie zainstalowana po przeładowaniu {APP_NAME}.",
    "EXTENSION_SEARCH_PLACEHOLDER"         : "Szukaj",
    "EXTENSION_MORE_INFO_LINK"             : "Więcej",
    "BROWSE_EXTENSIONS"                    : "Przeglądaj rozszerzenia",
    "EXTENSION_MANAGER_REMOVE"             : "Usuń rozszerzenie",
    "EXTENSION_MANAGER_REMOVE_ERROR"       : "Nie udało się usunąć rozszerzeń: {0}. {APP_NAME} zostanie zrestartowany.",
    "EXTENSION_MANAGER_UPDATE"             : "Zaktualizuj rozszerzenie",
    "EXTENSION_MANAGER_UPDATE_ERROR"       : "Nie udało się zaktualizować rozszerzeń: {0}. {APP_NAME} zostanie zrestartowany.",
    "EXTENSION_MANAGER_DISABLE"            : "Wyłącz rozszerzenie",
    "EXTENSION_MANAGER_DISABLE_ERROR"      : "Nie udało się wyłączyć rozszerzeń: {0}. {APP_NAME} zostanie zrestartowany.",
    "MARKED_FOR_REMOVAL"                   : "Zaznaczono do usunięcia",
    "UNDO_REMOVE"                          : "Cofnij",
    "MARKED_FOR_UPDATE"                    : "Zaznaczono do aktualizacji",
    "UNDO_UPDATE"                          : "Cofnij",
    "MARKED_FOR_DISABLING"                 : "Zaznaczono do wyłączenia",
    "UNDO_DISABLE"                         : "Cofnij",
    "CHANGE_AND_RELOAD_TITLE"              : "Zmień rozszerzenia",
    "CHANGE_AND_RELOAD_MESSAGE"            : "Aby zaktualizować, usunąć lub wyłączyć zaznaczone rozszerzenia, {APP_NAME} musi zostać zrestartowany. Zostaniesz poproszony o zapisanie zmian.",
    "REMOVE_AND_RELOAD"                    : "Usuń rozszerzenia i zrestartuj",
    "CHANGE_AND_RELOAD"                    : "Zmień rozszerzenia i zrestartuj",
    "UPDATE_AND_RELOAD"                    : "Zaktualizuj rozszerzenia i zrestartuj",
    "DISABLE_AND_RELOAD"                   : "Wyłącz rozszerzenia i zrestartuj",
    "PROCESSING_EXTENSIONS"                : "Przetwarzanie\u2026",
    "EXTENSION_NOT_INSTALLED"              : "Nie można usunąć rozszerzenia {0}, ponieważ nie zostało zainstalowane.",
    "NO_EXTENSIONS"                        : "Nie masz jeszcze żadnych rozszerzeń.<br>Użyj zakładki Dostępne (powyżej), aby zobaczyć listę.",
    "NO_EXTENSION_MATCHES"                 : "Nie znaleziono pasujących rozszerzeń.",
    "REGISTRY_SANITY_CHECK_WARNING"        : "Uwaga: te rozszerzenia mogą pochodzić od innych autorów i mają pełne uprawnienia. Uważaj gdy instalujesz rozszerzenia z nieznanych źródeł.",
    "EXTENSIONS_INSTALLED_TITLE"           : "Zainstalowane",
    "EXTENSIONS_DEFAULT_TITLE"             : "Domyślne",
    "EXTENSIONS_AVAILABLE_TITLE"           : "Dostępne",
    "EXTENSIONS_THEMES_TITLE"              : "Motywy",
    "EXTENSIONS_UPDATES_TITLE"             : "Aktualizacje",
    "EXTENSIONS_LAST_UPDATED"              : "Ostatnia aktualizacja",
    "EXTENSIONS_DOWNLOADS"                 : "Ilość pobrań",

    "INLINE_EDITOR_NO_MATCHES"             : "Brak wyników.",
    "INLINE_EDITOR_HIDDEN_MATCHES"         : "Wszystkie wyniki zostały zwinięte. Rozwiń listę plików po prawej, by pokazać wyniki.",
    "CSS_QUICK_EDIT_NO_MATCHES"            : "Brak reguł.<br> Kliknij \"Nowa reguła\", aby ją utworzyć.",
    "CSS_QUICK_EDIT_NO_STYLESHEETS"        : "W twoim projekcie brakuje stylów CSS.<br>Stwórz je, by móc dodawać reguły CSS.",

    // Custom Viewers
    "IMAGE_VIEWER_LARGEST_ICON"            : "największy",

    /**
     * Unit names
     */
    "UNIT_PIXELS"                          : "pikseli",

    // extensions/default/DebugCommands
    "DEBUG_MENU"                                : "Debuguj",
    "ERRORS"                                    : "Błędy",
    "CMD_SHOW_DEV_TOOLS"                        : "Pokaż narzędzia deweloperskie",
    "CMD_REFRESH_WINDOW"                        : "Uruchom ponownie z rozszerzeniami",
    "CMD_RELOAD_WITHOUT_USER_EXTS"              : "Uruchom ponownie bez rozszerzeń",
    "CMD_NEW_BRACKETS_WINDOW"                   : "Nowe okno",
    "CMD_LAUNCH_SCRIPT_MAC"                     : "Zainstaluj skrót do wiersza poleceń",
    "CMD_SWITCH_LANGUAGE"                       : "Zmień język",
    "CMD_RUN_UNIT_TESTS"                        : "Uruchom testy",
    "CMD_SHOW_PERF_DATA"                        : "Pokaż informacje o wydajności",
    "CMD_ENABLE_NODE_DEBUGGER"                  : "Włącz debugger Node",
    "CMD_LOG_NODE_STATE"                        : "Zapisz stan Node w konsoli",
    "CMD_RESTART_NODE"                          : "Zrestartuj Node",
    "CMD_SHOW_ERRORS_IN_STATUS_BAR"             : "Pokazuj błędy na pasku statusu",
    "CMD_OPEN_BRACKETS_SOURCE"                  : "Otwórz kod źródłowy {APP_NAME}",

    "CREATING_LAUNCH_SCRIPT_TITLE"              : "Skrót do wiersza poleceń {APP_NAME}",
    "ERROR_CREATING_LAUNCH_SCRIPT"              : "Błąd podczas instalacji skrótu wiersza poleceń. Przeczytaj artykuł <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting'>z propozycjami rozwiązania tego problemu.</a>.<br/><br/>Powód: {0}",
    "ERROR_CLTOOLS_RMFAILED"                    : "Nie można usunąć istniejącego dowiązania <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_MKDIRFAILED"                 : "Nie można utworzyć katalogu <code>/usr/local/bin</code>.",
    "ERROR_CLTOOLS_LNFAILED"                    : "Nie można utworzyć dowiązania <code>/usr/local/bin/brackets</code>.",
    "ERROR_CLTOOLS_SERVFAILED"                  : "Błąd wewnętrzny.",
    "ERROR_CLTOOLS_NOTSUPPORTED"                : "Skrót do wiersza poleceń nie jest dostępny w tym systemie.",
    "LAUNCH_SCRIPT_CREATE_SUCCESS"              : "Udało się! Teraz możesz uruchamiać {APP_NAME} z wiersza poleceń: <code>brackets plik.txt</code> aby otworzyć plik lub <code>brackets folder</code> aby zmienić projekt. <br/><br/><a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments'>Przeczytaj więcej</a> na temat używania {APP_NAME} w wierszu poleceń.",

    "LANGUAGE_TITLE"                            : "Zmień język",
    "LANGUAGE_MESSAGE"                          : "Język:",
    "LANGUAGE_SUBMIT"                           : "Zrestartuj {APP_NAME}",
    "LANGUAGE_CANCEL"                           : "Anuluj",
    "LANGUAGE_SYSTEM_DEFAULT"                   : "Domyślny systemu",

    // extensions/default/HealthData
    "HEALTH_DATA_NOTIFICATION"                  : "Ustawienia raportowania",
    "HEALTH_FIRST_POPUP_TITLE"                  : "Raporty {APP_NAME}",
    "HEALTH_DATA_DO_TRACK"                      : "Wysyłaj anonimowe informacje o tym, jak używam {APP_NAME}",
    "HEALTH_DATA_NOTIFICATION_MESSAGE"          : "Aby ciągle udoskonalać {APP_NAME}, co pewien czas wysyłamy <strong>anonimowe</strong> statystyki do Adobe na temat tego, jak korzystasz z edytora. Informacje te pomagają nam tworzyć lepsze funkcjonalności, wyszukiwać problemy czy poprawiać wygodę w korzystaniu z programu. <br><br>Możesz zobaczyć co przesyłamy lub wyłączyć przesyłanie danych w menu <strong>Pomoc > Raportowanie</strong>.<br><br><a href='https://github.com/adobe/brackets/wiki/Health-Data'>Przeczytaj więcej o raportach w {APP_NAME}</a>",
    "HEALTH_DATA_PREVIEW"                       : "Raporty {APP_NAME}",
    "HEALTH_DATA_PREVIEW_INTRO"                 : "<p>Aby ciągle udoskonalać {APP_NAME}, co pewien czas wysyłamy <strong>anonimowe</strong> statystyki do Adobe na temat tego, jak wykorzystujesz {APP_NAME}. Informacje te pomagają nam tworzyć lepsze funkcjonalności, znajdować problemy czy poprawiać wygodę w korzystaniu z programu. <a href='https://github.com/adobe/brackets/wiki/Health-Data'>Przeczytaj więcej o raportach w {APP_NAME}</a> oraz w jaki sposób pomaga to całej społeczności {APP_NAME}, jednocześnie dbając o twoją prywatność.</p><p>Poniżej możesz podejrzeć jakie dane zostaną przesłane w twoim następnym raporcie <em>jeżeli</em> jest u uaktywniony.</p>",

    // extensions/default/InlineTimingFunctionEditor
    "INLINE_TIMING_EDITOR_TIME"                 : "Czas",
    "INLINE_TIMING_EDITOR_PROGRESSION"          : "Postęp",
    "BEZIER_EDITOR_INFO"                        : "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Przenieś zaznaczony punkt<br><kbd class='text'>Shift</kbd> Przenieś o 10 jednostek<br><kbd class='text'>Tab</kbd> Zmień punkt",
    "STEPS_EDITOR_INFO"                         : "<kbd>↑</kbd><kbd>↓</kbd> Zwiększ lub zmniejsz kroki<br><kbd>←</kbd><kbd>→</kbd> 'Start' lub 'End'",
    "INLINE_TIMING_EDITOR_INVALID"              : "Poprzednia wartość <code>{0}</code> jest niepoprawna, więc została zamieniona na <code>{1}</code>. Dokument zostanie uaktualniony podczas pierwszej edycji.",

    // extensions/default/InlineColorEditor
    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP"     : "Aktualny kolor",
    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP"    : "Orginalny kolor",
    "COLOR_EDITOR_RGBA_BUTTON_TIP"              : "Format RGBa",
    "COLOR_EDITOR_HEX_BUTTON_TIP"               : "Format Hex",
    "COLOR_EDITOR_HSLA_BUTTON_TIP"              : "Format HSLa",
    "COLOR_EDITOR_0X_BUTTON_TIP"                : "Format Hex (0x)",
    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR"      : "{0} (użyto {1} raz)",
    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL"        : "{0} (użyto {1} razy)",

    // extensions/default/JavaScriptCodeHints
    "CMD_JUMPTO_DEFINITION"                     : "Przejdź do definicji",
    "CMD_SHOW_PARAMETER_HINT"                   : "Pokaż podpowiedź (parametr)",
    "NO_ARGUMENTS"                              : "<brak parametrów>",
    "DETECTED_EXCLUSION_TITLE"                  : "Błąd podczas sprawdzania poprawności kodu JavaScript",
    "DETECTED_EXCLUSION_INFO"                   : "{APP_NAME} napotkał problemy podczas przetwarzania pliku <span class='dialog-filename'>{0}</span>.<br><br>Plik nie będzie już przetwarzany w celu pokazywania podpowiedzi w kodzie, wykorzystywaniu Przejdź do definicji lub do Szybkiej Edycji. Aby przywrócić dla pliku te funkcjonalności, otwórz <code>.brackets.json</code> w swoim projekcie i edytuj plik <code>jscodehints.detectedExclusions</code>.<br><br>Jest to prawdopodobnie błąd {APP_NAME}. Jeżeli chcesz dostarczyć kopię tego pliku, prosimy <a href='https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue'>prześlij plik z błędem</a>.",

    // extensions/default/JSLint
    "JSLINT_NAME"                               : "JSLint",

    // extensions/default/QuickView
    "CMD_ENABLE_QUICK_VIEW"                     : "Szybki Podgląd po najechaniu na element",

    // extensions/default/RecentProjects
    "CMD_TOGGLE_RECENT_PROJECTS"                : "Ostatnie projekty",

    // extensions/default/MDNDocs
    "DOCS_MORE_LINK"                            : "Czytaj więcej",
    
    // extensions/default/CodeFolding
    "COLLAPSE_ALL"                  : "Zwiń wszystko",
    "EXPAND_ALL"                    : "Rozwiń wszystko",
    "COLLAPSE_CURRENT"              : "Zwiń element",
    "EXPAND_CURRENT"                : "Rozwiń element",

    // extensions/default/NavigationAndHistory
    "RECENT_FILES_DLG_HEADER"                    : "Ostatnio otwierane pliki",
    "RECENT_FILES_DLG_CLEAR_BUTTON_LABEL"        : "Wyczyść",
    "RECENT_FILES_DLG_CLEAR_BUTTON_TITLE"        : "Wyczyść pliki (oprócz aktualnie otwartych)",

    // Descriptions of core preferences
    "DESCRIPTION_CLOSE_BRACKETS"                     : "true, by automatycznie zamykać nawiasy okrągłe, kwadratowe i klamrowe",
    "DESCRIPTION_CLOSE_OTHERS_ABOVE"                 : "false, by usunąć pozycję \"Zamknij pliki powyżej\" z menu kontekstowego plików w obszarze roboczym",
    "DESCRIPTION_CLOSE_OTHERS_BELOW"                 : "false, by usunąć pozycję \"Zamknij pliki poniżej\" z menu kontekstowego plików w obszarze roboczym",
    "DESCRIPTION_CLOSE_OTHERS"                       : "false, by usunąć pozycję \"Zamknij inne\" z menu kontekstowego plików w obszarze roboczym",
    "DESCRIPTION_CLOSE_TAGS"                         : "Opcje automatycznego zamykania tagów",
    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS"         : "lista tagów, które nie powinny być automatycznie zamykane",
    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING"            : "zamykaj znaczniki po wpisaniu \">\" otwierającego tagu",
    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING"            : "zamykaj znaczniki po wpisaniu \"/\" zamykającego tagu",
    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS"             : "lista tagów, które wstawiają pustą linie (po wpisaniu otwierającego znacznika)",
    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD" : "true, by generować znaczniki zwijania kodu na podstawie poziomów wcięć",
    "DESCRIPTION_CODE_FOLDING_ENABLED"               : "true, by włączyć zwijanie kodu",
    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER"  : "true, by wyświetlać znaczniki zwijania kodu po najechaniu kursora myszy na boczny panel",
    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL"        : "Określa do ilu poziomów głębokości zostanie zastosowana funkcja \"Zwiń wszystko\"",
    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE"         : "Minimalna liczba linii wymagana do pojawienia się znacznika zwijania kodu",
    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES"      : "true, by zapamiętać zwinięte fragmenty kodu, gdy plik lub projekt zostanie zamknięty bądź ponownie otwarty",
    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "true, by zezwolić na zwijanie zaznaczonego fragmentu kodu",
    "DESCRIPTION_DISABLED_DEFAULT_EXTENSIONS"        : "Lista rozszerzeń, które są domyślnie wyłączone",
    "DESCRIPTION_ATTR_HINTS"                         : "Włącz/wyłącz podpowiedzi do atrybutów HTML",
    "DESCRIPTION_CSS_PROP_HINTS"                     : "Włącz/wyłącz podpowiedzi do właściwości CSS/LESS/SCSS",
    "DESCRIPTION_JS_HINTS"                           : "Włącz/wyłącz podpowiedzi do kodu JavaScript",
    "DESCRIPTION_JS_HINTS_TYPE_DETAILS"              : "Włącz/wyłącz wyświetlanie typów danych w podpowiedziach do kodu JavaScript",
    "DESCRIPTION_PREF_HINTS"                         : "Włącz/wyłącz podpowiedzi w pliku z ustawieniami",
    "DESCRIPTION_SPECIAL_CHAR_HINTS"                 : "Włącz/wyłącz podpowiedzi dla encji HTML",
    "DESCRIPTION_SVG_HINTS"                          : "Włącz/wyłącz podpowiedzi do kodu SVG",
    "DESCRIPTION_HTML_TAG_HINTS"                     : "Włącz/wyłącz podpowiedzi do tagów HTML",
    "DESCRIPTION_URL_CODE_HINTS"                     : "Włącz/wyłącz podpowiedzi URL w kodzie HTML i CSS/LESS/SCSS",
    "DESCRIPTION_DRAG_DROP_TEXT"                     : "Włącz/wyłącz funkcjonalność przeciągnij i upuść",
    "DESCRIPTION_HEALTH_DATA_TRACKING"               : "Włącz raportowanie o stanie programu",
    "DESCRIPTION_HIGHLIGHT_MATCHES"                  : "Zezwól na automatyczne podświetlanie dopasowanych wyrazów w dokumencie",
    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN"       : "Podświetl wszystkie wyrazy dopasowane według słowa z aktualnej pozycji kursora (bez zaznaczania)",
    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY"       : "Podświetl, tylko gdy zaznaczony jest cały wyraz",
    "DESCRIPTION_INSERT_HINT_ON_TAB"                 : "true, by wstawić podpowiedź do kodu po naciśnięciu klawisza tab",
    "DESCRIPTION_NO_HINTS_ON_DOT"                    : "true, by nie pokazywać automatycznie podpowiedzi do kodu JS po wpisaniu znaku \".\"",
    "DESCRIPTION_JSLINT_OPTIONS"                     : "Obiekt z domyślnymi ustawieniami JSLint",
    "DESCRIPTION_JSLINT_OPTIONS_ASS"                 : "true, by zezwolić na wyrażenia przypisania",
    "DESCRIPTION_JSLINT_OPTIONS_BITWISE"             : "true, by zezwolić na używanie operatorów bitowych",
    "DESCRIPTION_JSLINT_OPTIONS_BROWSER"             : "true, jeśli standardowe zmienne (globalne) przeglądarki powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE"             : "true, by zezwolić na Google Closure idioms",
    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE"            : "true, by zezwolić na używanie instrukcji \"continue\"",
    "DESCRIPTION_JSLINT_OPTIONS_COUCH"               : "true, jeśli zmienne globalne dla CouchDB powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_DEBUG"               : "true, by zezwolić na instrukcje debugera",
    "DESCRIPTION_JSLINT_OPTIONS_DEVEL"               : "true, jeśli zmienne globalne przeglądarki (użyteczne podczas projektowania) powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_EQEQ"                : "true, by zezwolić na użycie == i !=",
    "DESCRIPTION_JSLINT_OPTIONS_ES6"                 : "true, jeśli zmienne globalne standardu ES6 powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_EVIL"                : "true, by zezwolić na używanie wyrażenia eval",
    "DESCRIPTION_JSLINT_OPTIONS_FORIN"               : "true, by zezwolić na niefiltrowaną instrukcje \"for ... in\"",
    "DESCRIPTION_JSLINT_OPTIONS_INDENT"              : "określa szerokość wcięcia",
    "DESCRIPTION_JSLINT_OPTIONS_MAXERR"              : "maksymalna liczba raportowanych ostrzeżeń",
    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN"              : "maksymalna liczba znaków w jednej linii",
    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP"              : "true, by zezwolić na definiowanie konstruktora nierozpoczynającego się od wielkiej litery",
    "DESCRIPTION_JSLINT_OPTIONS_NODE"                : "true, jeśli zmienne globalne dla Node.js powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_NOMEN"               : "true, by zezwolić na użycie znaku \"_\" w zmiennych",
    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL"            : "true, by zatrzymać analizę po wystąpieniu pierwszego błędu",
    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS"            : "true, by zezwolić na ++ i --",
    "DESCRIPTION_JSLINT_OPTIONS_REGEXP"              : "true, by zezwolić na . i [^...]. w wyrażeniach regularnych",
    "DESCRIPTION_JSLINT_OPTIONS_RHINO"               : "true, jeśli zmienne globalne dla Rhino powinny być predefiniowane",
    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY"              : "true, by zezwolić na ominięcie definicji `use strict`",
    "DESCRIPTION_JSLINT_OPTIONS_STUPID"              : "true, by zezwolić na używanie blokowanych metod ('...Sync')",
    "DESCRIPTION_JSLINT_OPTIONS_SUB"                 : "true, by zezwolić na dostęp do właściwości obiektu za pomocą nawiasów kwadratowych (subscript notation)",
    "DESCRIPTION_JSLINT_OPTIONS_TODO"                : "true, by zezwolić na komentarze typu TODO",
    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM"             : "true, by zezwolić na pozostawienie nieużywanych parametrów funkcji",
    "DESCRIPTION_JSLINT_OPTIONS_VARS"                : "true, by zezwolić na użycie więcej niż jednej deklaracji var w funkcji",
    "DESCRIPTION_JSLINT_OPTIONS_WHITE"               : "true, by ignorować zasady białych znaków",
    "DESCRIPTION_LANGUAGE"                           : "Ustawienia języka",
    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS"           : "Dodatkowe mapowanie nazwy rozszerzenia z nazwą języka",
    "DESCRIPTION_LANGUAGE_FILE_NAMES"                : "Dodatkowe mapowanie nazwy pliku z nazwą języka",
    "DESCRIPTION_LINEWISE_COPY_CUT"                  : "Kopiuj lub wytnij całą linie, gdy nie został zaznaczony żaden fragment tekstu",
    "DESCRIPTION_INPUT_STYLE"                        : "Wybiera sposób, w jaki CodeMirror obsługuje wejście oraz aktywność. Wartością może być textarea (domyślnie) lub contenteditable, która jest lepsza dla czytników ekranu (niestabilne)",
    "DESCRIPTION_LINTING_ENABLED"                    : "true, by włączyć inspekcje kodu (Code Inspection)",
    "DESCRIPTION_ASYNC_TIMEOUT"                      : "Limit czasu (w milisekundach), którego nie mogą przekroczyć asynchroniczne lintery",
    "DESCRIPTION_LINTING_PREFER"                     : "Lista linterów do uruchomienia w pierwszej kolejności",
    "DESCRIPTION_LIVE_DEV_MULTIBROWSER"              : "true, by włączyć eksperymentalny podgląd na żywo",
    "DESCRIPTION_USE_PREFERED_ONLY"                  : "true, by uruchomić tylko te moduły, które zostały określone w linting.prefer",
    "DESCRIPTION_MAX_CODE_HINTS"                     : "Maksymalna liczba pozycji w liście podpowiedzi do kodu",
    "DESCRIPTION_PATH"                               : "Ścieżka do ustawień",
    "DESCRIPTION_PROXY"                              : "Adres URL serwera proxy używanego do instalacji rozszerzeń",
    "DESCRIPTION_SCROLL_PAST_END"                    : "true, by włączyć możliwość przewijania poza koniec dokumentu",
    "DESCRIPTION_SHOW_CODE_HINTS"                    : "false, by wyłączyć wszystkie podpowiedzi do kodu",
    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING"         : "Wyświetlaj migający kursor podczas zaznaczenia tekstu",
    "DESCRIPTION_SHOW_LINE_NUMBERS"                  : "true, by wyświetlać numery linii obok kodu",
    "DESCRIPTION_SMART_INDENT"                       : "Automatycznie dodaj wcięcie, gdy zostanie utworzona nowa linia",
    "DESCRIPTION_SOFT_TABS"                          : "false, by wyłączyć soft tabs",
    "DESCRIPTION_SORT_DIRECTORIES_FIRST"             : "true, by sortować foldery w drzewie projektu",
    "DESCRIPTION_SPACE_UNITS"                        : "Liczba spacji lub tabulatorów do sformatowania wcięcia w kodzie",
    "DESCRIPTION_STATIC_SERVER_PORT"                 : "Numer portu, który powinien być używany przez wbudowany serwer podczas podglądu na żywo",
    "DESCRIPTION_STYLE_ACTIVE_LINE"                  : "true, by podświetlać tło dla aktualnie edytowanej linii",
    "DESCRIPTION_TAB_SIZE"                           : "Określ rozmiar tabulatora (według liczby spacji)",
    "DESCRIPTION_USE_TAB_CHAR"                       : "true, by używać tabulatorów zamiast spacji",
    "DESCRIPTION_UPPERCASE_COLORS"                   : "true, by generować kolory w formacie szesnastkowym (hex) używając wielkich liter w liniowym edytorze kolorów",
    "DESCRIPTION_WORD_WRAP"                          : "Zawijaj wiersze",
    "DESCRIPTION_DETECTED_EXCLUSIONS"                : "Lista plików, które zostały wykryte jako problematyczne dla modułu Tern",
    "DESCRIPTION_INFERENCE_TIMEOUT"                  : "Limit czasu, którego moduł Tern nie może przekroczyć podczas analizy plików",
    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR"          : "true, by wyświetlać błędy aplikacji w pasku stanu",
    "DESCRIPTION_QUICK_VIEW_ENABLED"                 : "true, by włączyć Quick View",
    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW"       : "true, by wyświetlać podgląd dla grafiki, która nie posiada rozszerzenia w adresie URL",
    "DESCRIPTION_THEME"                              : "Wybierz motyw dla {APP_NAME}",
    "DESCRIPTION_USE_THEME_SCROLLBARS"               : "true, by zezwolić na modyfikacje pasków przewijania przez motyw",
    "DESCRIPTION_LINTING_COLLAPSED"                  : "true, by zwijać (ukrywać) panel inspekcji kodu",
    "DESCRIPTION_FONT_FAMILY"                        : "Rodzaj czcionki",
    "DESCRIPTION_FONT_SIZE"                          : "Rozmiar czcionki, np. 13px",
    "DESCRIPTION_FIND_IN_FILES_NODE"                 : "true, by włączyć wyszukiwanie oparte na NodeJS",
    "DESCRIPTION_FIND_IN_FILES_INSTANT"              : "true, by zezwolić na natychmiastowe wyszukiwanie",
    "DESCRIPTION_FONT_SMOOTHING"                     : "Tylko dla MacOS: \"subpixel-antialiased\" włącz sub-pixel antialiasing lub \"antialiased\" dla antyaliasingu skali szarości",
    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW"           : "false, by wyłączyć otwieranie pliku z ustawieniami w podzielonym widoku",
    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE"     : "false, by wyłączyć otwieranie pliku z ustawieniami użytkownika w lewym/górnym panelu",
    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED"  : "true, by automatycznie włączyć tryb \"bez podziału\", gdy ostatni plik w panelu zostanie zamknięty (za pomocą przyciku w nagłówku panelu)",
    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS"           : "Określ, kiedy powinny być wyświetlane przyciski zamknięcia i odwrócenia widoku w nagłówku panelu",
    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT"        : "/*\n * This is a read-only file with the preferences supported\n * by {APP_NAME}.\n * Use this file as a reference to modify your preferences\n * file \"brackets.json\" opened in the other pane.\n * For more information on how to use preferences inside\n * {APP_NAME}, refer to the web page at https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\n */",
    "DEFAULT_PREFERENCES_JSON_DEFAULT"               : "Domyślnie",
    "DESCRIPTION_PURE_CODING_SURFACE"                : "true, by włączyć tryb \"bez przeszkadzania\" i ukryć wszystkie inne elementy UI w {APP_NAME}",
    "DESCRIPTION_INDENT_LINE_COMMENT"                : "true, by włączyć wcięcia w komentarzach",
    "DESCRIPTION_RECENT_FILES_NAV"                   : "Włącz/wyłącz nawigację w ostatnich plikach",
    "DESCRIPTION_LIVEDEV_WEBSOCKET_PORT"             : "Port, na którym będzie uruchomiony serwer WebSocket podczas podglądu na żywo"
});

/* Last translated for a01159ac2518fe1f27dfafb62d95a28c2958831f */